import SelectionListener from "../SelectionListener.js";
import WindowManager from "../WindowManager.js";
import QuickGalleryForm from "../forms/QuickGalleryForm.js";

class MakeQuickGalleryButton{
	/**
	 * @type {ImageManager}
	 */
	imageManager;

	/**
	 * @type {HTMLButtonElement}
	 */
	button;

	/**
	 * @param {ImageManager} imageManager
	 */
	constructor(imageManager){
		this.imageManager = imageManager;
		this.button = imageManager.container.querySelector(".im-quick-gallery-button");
		this.button.addEventListener("click", () => {
			this.onClicked();
		});
	}


	onClicked(){
		const currentSelection = this.imageManager.selectionListener.currentImageComponentSelection;
		if (currentSelection.length > 1){
			document.querySelector("#im-quick-gallery-num-images").textContent = String(currentSelection.length);
			this.imageManager.quickGalleryForm.imageComponentsToUse = currentSelection;
			this.imageManager.windowManager.show(WindowManager.WINDOWS.QUICK_GALLERY);
		}
	}
}

export default MakeQuickGalleryButton;