import SelectionListener from "../SelectionListener.js";

class InsertImagesButton{
	/**
	 * @type {ImageManager}
	 */
	imageManager = null;

	/**
	 * @param {ImageManager} imageManager
	 */
	constructor(imageManager){
		this.imageManager = imageManager;
		this.button = document.querySelector("#im-insert-images-button");

		this.button.addEventListener("click", () => {
			this.onButtonClicked();
		});
	}

	onButtonClicked(){
		this.imageManager.fireImagesInserted(this.imageManager.selectionListener.currentImageComponentSelection);
	}
}

export default InsertImagesButton;