class FilterImages{
	imageManager = null;

	constructor(imageManager){
		this.imageManager = imageManager;

		/** @property {HTMLFormElement} queryInput */
		this.form = document.querySelector("#im-filter-current-location-form");

		/** @property {HTMLInputElement} queryInput */
		this.queryInput = this.form.querySelector(`[name="filter-query"]`);

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.filterImagesByQuery(this.queryInput.value.trim());
		});

		this.queryInput.addEventListener("input", e => {
			this.filterImagesByQuery(this.queryInput.value.trim());
		});
	}

	/**
	 * Filters the images currently shown by the provided query
	 * @param {string} query
	 */
	filterImagesByQuery(query){
		query = query.toLowerCase();
		/** @type {NodeList} imageElements */
		const imageElements = document.querySelectorAll("im-window-body .im-images im-image");

		for (/** @type {HTMLElement} element */ const element of imageElements){
			const imageName = element.querySelector(".image-file-name").textContent.trim().toLowerCase();
			if (imageName.includes(query) || query === ""){
				element.style.display = "flex";
			}else{
				element.style.display = "none";
			}
		}
	}
}

export default FilterImages;