class ImageManagerState{
	imageManager = null;

	constructor(imageManager) {
		this.imageManager = imageManager;
		this.IMAGE_MODES = {
			NONE: 0, // For when no insert or select button should appear
			INSERT: 1,
			SELECT: 2
		};

		this.imageMode = this.IMAGE_MODES.INSERT;
		this.baseImagesDirectory = null;
		this.currentDirectory = null;

		/**
		 * Flag to stop the "upload window" appearing when the user is dragging a ImageManager component.
		 * @type {boolean}
		 */
		this.isDraggingComponent = false;

		/**
		 * The currently dragged image component
		 * @type {ImageComponent}
		 */
		this.currentlyDraggedImageComponent = null;

		/**
		 * The currently dragged folder component
		 * @type {SidebarFolderComponent}
		 */
		this.currentlyDraggedFolderComponent = null;

		/**
		 * This is appended to all thumb images when images are loaded into
		 * the image manager. Changing this string will force all of them
		 * to cache-refresh and is usually done after an image is modified
		 * to make sure the newest version of the thumb image is shown to the user in
		 * the sidebar of the image manager.
		 * @type {string}
		 */
		this.currentImageCacheRandomString = String(Math.random());

		// Flag reset for dragging an image component
		window.addEventListener("drop", e => {
			if (this.isDraggingComponent === true){
				// Reset this flag
				this.isDraggingComponent = false;
			}
		});
	}

	/**
	 * Sets the mode in which a select selection is handle.
	 * @param {int} imageMode
	 */
	setImageMode(imageMode){
		this.imageMode = imageMode;
	}
}

export default ImageManagerState;