import Endpoints from "../../Endpoints.js";
import GalleryRow from "../components/GalleryRow.js";

class RenameGalleryForm{
	/**
	 * @type {ImageGallery}
	 */
	imageGallery;

	/**
	 * @param {ImageGallery} imageGallery
	 */
	constructor(imageGallery){
		this.imageGallery = imageGallery;
		this.isProcessing = false;
		this.form = document.querySelector("#rename-gallery-form");

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.imageGallery.renameGalleryModal.errorContainer.style.display = "none";

		const fData = new FormData(this.form);

		const response = await fetch(`${Endpoints.galleries.renameGallery}/${this.imageGallery.manageGalleryModal.currentGalleryID}/name`, {
			credentials:"same-origin",
			cache:"no-cache",
			body:fData,
			method:"PATCH"
		});

		/** @type {{status: int, error: ?string, newName: string}} */
		let data;
		try {
			data = await response.json();
		}catch(jsonError){
			this.imageGallery.renameGalleryModal.errorContainer.style.display = "block";
			this.imageGallery.renameGalleryModal.errorContainer.textContent = "Server sent back an invalid JSON response.";
			this.isProcessing = false;
			return;
		}

		if (data.status === 1){
			// Rename the gallery on the client side
			// Manage gallery modal title and the gallery row object
			// Sanitized, if necessary
			const newName = data.newName;

			// Change the title in the gallery manager modal
			this.imageGallery.renameGalleryModal.modal.querySelector(".modal-title").textContent = newName;

			// Rename the GalleryRow DOM
			const galleryRow = GalleryRow.getByGalleryID(this.imageGallery.manageGalleryModal.currentGalleryID);
			galleryRow.name = newName;
			galleryRow.dom.querySelector(".name").textContent = newName;

			this.imageGallery.renameGalleryModal.hideModal();
			this.imageGallery.renameGalleryModal.showModal();
		}else if (data.status === -1){
			this.imageGallery.renameGalleryModal.errorContainer.style.display = "block";
			this.imageGallery.renameGalleryModal.errorContainer.textContent = data.error;
		}

		this.isProcessing = false;
	}
}

export default RenameGalleryForm;