import Endpoints from "../../Endpoints.js";
import ImageGallery from "../ImageGallery.js";

class NewGalleryForm{
	/**
	 * @type {ImageGallery}
	 */
	imageGallery;

	/**
	 * @param {ImageGallery} imageGallery
	 */
	constructor(imageGallery){
		this.imageGallery = imageGallery;
		this.isProcessing = false;
		this.form = document.querySelector("#new-gallery-form");

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.imageGallery.newGalleryModal.errorContainer.style.display = "none";

		const fData = new FormData(this.form);

		const response = await fetch(Endpoints.galleries.newGallery, {
			credentials:"same-origin",
			cache:"no-cache",
			body:fData,
			method:"PUT"
		});

		if (response.status === 200){
			/** @type {{status: int, error: ?string, newGallery: Object}} */
			let data;
			try {
				data = await response.json();
			}catch(jsonError){
				this.imageGallery.newGalleryModal.errorContainer.style.display = "block";
				this.imageGallery.newGalleryModal.errorContainer.textContent = "The server responded with 200-OK, but the response was not in valid JSON.";
				this.isProcessing = false;
				return;
			}
			if (data.status === 1){
				/** @type {{name: string, id: int, creationTime: int, numImagesInGallery: int}} */
				// const newGallery = data.newGallery;
				this.imageGallery.newGalleryModal.hideModal();
				ImageGallery.renderGalleries(await ImageGallery.fetchGalleries());
			}else if (data.status === -1){
				this.imageGallery.newGalleryModal.errorContainer.style.display = "block";
				this.imageGallery.newGalleryModal.errorContainer.textContent = data.error;
			}
		}else{
			this.imageGallery.newGalleryModal.errorContainer.style.display = "block";
			this.imageGallery.newGalleryModal.errorContainer.textContent = "There was an internal server error. Use the dev tools network inspector to diagnose the error.";
		}

		this.isProcessing = false;
	}
}

export default NewGalleryForm;