import ImageGallery from "../ImageGallery.js";

class GalleryRow{
	static container = document.querySelector("#gallery-rows-container");
	static rows = [];

	static clearRows(){
		for (const row of GalleryRow.rows){
			row.dom.remove();
		}

		GalleryRow.rows = [];
	}

	/**
	 * @param {int} galleryID}
	 * @return {GalleryRow}
	 */
	static getByGalleryID(galleryID){
		for (const row of GalleryRow.rows){
			if (galleryID === row.id){
				return row;
			}
		}

		return null;
	}

	constructor(id, name, numImagesInGallery, creationTimestamp){
		this.id = id;
		this.name = name;
		this.numImagesInGallery = numImagesInGallery;
		this.creationTimestamp = creationTimestamp;
		this.dom = this.getDOM();

		// Add it to the DOM
		GalleryRow.container.append(this.dom);
		GalleryRow.rows.push(this);
	}

	/**
	 * @return {HTMLDivElement}
	 */
	getDOM(){
		const template = document.createElement("div");
		const creationDateTime = new Date(parseInt(this.creationTimestamp) * 1000);
		template.classList.add("gallery-row-item");
		template.classList.add("gallery-table-columns");
		template.innerHTML = `
			<div class="icon">
				<i class="bi bi-folder-fill"></i>
			</div>
			<div class="name">
				<span>${this.name}</span>
			</div>
			<div class="image-member-count">
				<span>${this.numImagesInGallery}</span>
			</div>
			<div class="creation-time">
				<span>${creationDateTime.toLocaleDateString()}</span>
			</div>
		`;

		template.addEventListener("click", () => {
			const manageGalleryModal = ImageGallery.manageGalleryModal;
			manageGalleryModal.currentGalleryID = this.id;
			manageGalleryModal.titleContainer.textContent = this.name;
			manageGalleryModal.showModal();
			manageGalleryModal.loadMembers(this.id);
		});

		return template;
	}
}

export default GalleryRow;