import BodyEditor from "../components/BodyEditor.js";
import HeadEditor from "../components/HeadEditor.js";
import EditorsContainer from "../components/EditorsContainer.js";
import SubmitPageBuildButton from "../components/SubmitPageBuildButton.js";
import Loader from "../components/Loader.js";
import ImportWebsiteContainer from "../components/ImportWebsiteContainer.js";
import Scheduler from "../../utils/Scheduler.js";

class FetchURLForm{
	form = document.querySelector("#crawl-form");
	isProcessing = false;

	constructor(){
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		Loader.show();
		ImportWebsiteContainer.hide();

		const fData = new FormData(this.form);
		const urlSearchParams = new URLSearchParams();
		urlSearchParams.set("url", fData.get("url"));

		const response = await fetch(`/uplift/external-importer/fetch?${urlSearchParams.toString()}`, {
		    method:"GET",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
		    /** @type {{status: int, error: ?string, head: string, body: string}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
		    return;
		}

		await Scheduler.wait(850);
		Loader.hide();
		ImportWebsiteContainer.show();

		if (data.status === 1){
			BodyEditor.aceEditorExtension.ace.getSession().setValue(data.body);
			HeadEditor.aceEditorExtension.ace.getSession().setValue(data.head);
			SubmitPageBuildButton.show();
			EditorsContainer.show();
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
	}
}

export default new FetchURLForm()