import HeadEditor from "./HeadEditor.js";
import BodyEditor from "./BodyEditor.js";
import FetchURLForm from "../forms/FetchURLForm.js";
import BuildPageForm from "../forms/BuildPageForm.js";
import SuccessBox from "./SuccessBox.js";
import ImportWebsiteContainer from "./ImportWebsiteContainer.js";
import EditorsContainer from "./EditorsContainer.js";
import PageCityDataContainer from "./PageCityDataContainer.js";

class ImportNewPageButton{
	button = document.querySelector("#import-another-page-button");

	constructor(){
		this.button.addEventListener("click", () => {
			this.onClick();
		});
	}

	onClick(){
		const pageTypeValue = document.querySelector("#page-type-input").selectedOptions[0].value;
		HeadEditor.aceEditorExtension.ace.getSession().setValue("");
		BodyEditor.aceEditorExtension.ace.getSession().setValue("");
		FetchURLForm.form.reset();
		BuildPageForm.resetFields();
		EditorsContainer.hide();
		SuccessBox.hide();
		ImportWebsiteContainer.show();
		PageCityDataContainer.hideFields(pageTypeValue);
	}
}

export default new ImportNewPageButton();