class Breadcrumb{
	/**@type {Breadcrumb[]} */
	static cache = [];
	static container = document.querySelector("#breadcrumbs-components-container");
	static nextID = 0;

	/**
	 *
	 * @param {Breadcrumb} crumb
	 */
	static removeFromCache(crumb){
		for (const crumbIndex in Breadcrumb.cache){
			const cacheCrumb = Breadcrumb.cache[crumbIndex];
			if (cacheCrumb.id === crumb.id){
				Breadcrumb.cache.splice(parseInt(crumbIndex), 1);
				break;
			}
		}
	}

	dom = null;
	labelInput = null;
	uriInput = null;

	constructor() {
		this.id = Breadcrumb.nextID++;
		this.dom = this.getDOM();
		Breadcrumb.container.append(this.dom);

		Breadcrumb.cache.push(this);
	}

	getDOM(){
		const template = document.createElement("div");
		template.classList.add("external-importer-breadcrumb-component");
		template.innerHTML = `
			<div class="label-container">
				<label>Crumb label</label>
				<div class="input-group">
					<span class="input-group-text"><i class="bi bi-input-cursor-text"></i></span>
					<input type="text" class="form-control label-input">
				</div>
			</div>
			<div class="uri-container">
				<label>Crumb URI</label>
				<div class="input-group">
					<span class="input-group-text"><i class="bi bi-input-cursor-text"></i></span>
					<input type="text" class="form-control uri-input">
				</div>
			</div>
			<div class="buttons-container">
				<button type="button" class="prefill-crumb-button btn btn-primary">
					<i class="bi bi-filter-square-fill"></i>
					<span>Prefill</span>
				</button>
				<button type="button" class="delete-crumb-button btn btn-danger">
					<i class="bi bi-trash-fill"></i>
					<span>Remove</span>
				</button>
			</div>
		`;

		this.labelInput = template.querySelector(".label-input");
		this.uriInput = template.querySelector(".uri-input");

		const deleteButton = template.querySelector(".delete-crumb-button");
		deleteButton.addEventListener("click", () => {
			this.onDeleteButtonClicked();
		});

		const prefillButton = template.querySelector(".prefill-crumb-button");
		prefillButton.addEventListener("click", () => {
			this.onPrefillCrumbButtonClicked();
		});

		return template;
	}

	onDeleteButtonClicked(){
		Breadcrumb.removeFromCache(this);
		this.dom.remove();
	}

	onPrefillCrumbButtonClicked(){
		this.uriInput.value = document.querySelector("#page-route-input").value;
		this.labelInput.value = document.querySelector("#page-name-input").value;
	}
}

export default Breadcrumb;