import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";
import IPPReelModal from "../modals/IPPReelModal.js";

class IPPReelShortcodeButton{
	constructor(){
		if (PageEditorStates.viewType !== "REVISION"){
			this.button = document.querySelector("#ipp-reel-shortcode-button");

			this.button.addEventListener("click", () => {
				this.onButtonClicked();
			});
		}
	}

	/**
	* When one of the inner buttons inside the main shortcode
	* button is clicked
	*/
	onButtonClicked(){
		IPPReelModal.showModal();
	}

	/**
	* Usually called from the modal's form when it's submitted.
	* Will inject the shortcode into the current editor
	* @param {int} numProjectsPerPage
	* @param {int} numColumns
	* @param {string[]} includedTagIDs
	* @param {string[]} excludedTagIDs
	*/
	injectShortcode(numProjectsPerPage, numColumns, includedTagIDs, excludedTagIDs){
		includedTagIDs = JSON.stringify(includedTagIDs);
		excludedTagIDs = JSON.stringify(excludedTagIDs);
		const shortcodeText = `{{ get-ipps ipps-per-page="${numProjectsPerPage}" columns="${numColumns}" included-project-tags="${includedTagIDs}" excluded-project-tags="${excludedTagIDs}" }}`
		EditorWrapper.insertTextAtCursor(shortcodeText);
		IPPReelModal.hideModal();
		EditorWrapper.focusEditor();
	}
}

export default (new IPPReelShortcodeButton);
