import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";

class FaxNumbersShortcodeButton{
	constructor(){
		if (PageEditorStates.viewingState !== ""){
			this.button = document.querySelector("#fax-number-shortcode-button");

			// Phone number logic has dropdown buttons
			const dropdown = this.button.parentNode.querySelector(".dropdown");
			const innerButtons = dropdown.querySelectorAll("button");
			for (let button of innerButtons){
				button.addEventListener("click", () => {
					this.onInnerButtonClicked(button);
				});
			}
		}
	}

	/**
	* When one of the inner buttons inside of the main shortcode
	* button is clicked
	* @param {HTMLButtonElement} button HTML DOMNode
	*/
	onInnerButtonClicked(button){
		const numberIndex = parseInt(button.getAttribute("number-index"));
		if (!isNaN(numberIndex)){
			const shortcodeText = `{{ fax-number which='${numberIndex}' }}`;
			EditorWrapper.insertTextAtCursor(shortcodeText);
			EditorWrapper.focusEditor();
		}
	}
}

export default (new FaxNumbersShortcodeButton);
