import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";

class CompanyNameShortcodeButton{
	constructor(){
		if (PageEditorStates.viewingState !== ""){
			this.button = document.querySelector("#company-name-shortcode-button");

			this.button.addEventListener("click", () => {
				this.onButtonClicked();
			});
		}
	}

	/**
	* When the shortcode button is clicked
	*/
	onButtonClicked(){
			const shortcodeText = `{{ company-name }}`;
			EditorWrapper.insertTextAtCursor(shortcodeText);
			EditorWrapper.focusEditor();
	}
}

export default (new CompanyNameShortcodeButton);
