import BSModal from "../../../_external/bootstrap/modal.js";
import ProjectTagsManageModal from "./ProjectTagsManageModal.js";
import PageEditorStates from "../PageEditorStates.js";

class RenameProjectTagModal{
	constructor(){
		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.modal = document.querySelector("#rename-project-tag-modal");
		this.projectTagID = null;
		this.renameInput = this.modal.querySelector("#renamed-project-tag-label");
		this.bsModal = new BSModal(this.modal);

		this.modal.addEventListener("hidden.bs.modal", () => {
			ProjectTagsManageModal.showModal();
		});
	}

	/**
	* Forces the modal to be shown
	*/
	showModal(){
		this.bsModal.show();
	}

	/**
	* Forces the modal to be hidden
	*/
	hideModal(){
		this.bsModal.hide();
	}
}

export default (new RenameProjectTagModal);
