import BSModal from "../../../_external/bootstrap/modal.js";
import PageEditorStates from "../PageEditorStates.js";
import RecentArticlesCategoryButton from "../components/RecentArticlesCategoryButton.js";
import Scheduler from "../../../utils/Scheduler.js";

class RecentArticlesModal{

	isProcessing = false;
	loader = document.querySelector("#recent-articles-categories-loader");
	noCategoriesMessage = document.querySelector("#recent-articles-no-article-categories");

	constructor(){

		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.modal = document.querySelector("#recent-articles-modal");
		this.bsModal = new BSModal(this.modal);
		this.modal.addEventListener("show.bs.modal", () => {
			this.fetchArticleCategories();
		})
	}

	/**
	* Forces the modal to be shown
	*/
	showModal(){
		this.bsModal.show();
	}

	/**
	* Forces the modal to be hidden
	*/
	hideModal(){
		this.bsModal.hide();
	}

	async fetchArticleCategories(){

		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.loader.style.display = null;
		RecentArticlesCategoryButton.clearAll();

		const response = await fetch(`/uplift/page-editor/article-categories`, {
		    method:"GET",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		await Scheduler.wait(550);

		let data;
		try{
		    /** @type {{status: int, error: ?string, categories: Object[]}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			this.isProcessing = false;
		    return;
		}

		if (data.status === 1){
			if (data.categories.length > 0) {
				this.noCategoriesMessage.style.display = "none";
				for (/** @type{{id: int, name: string}} */ const category of data.categories) {
					new RecentArticlesCategoryButton(category.id, category.name);
				}
			}else{
				this.noCategoriesMessage.style.display = null;
			}
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
		this.loader.style.display = "none";
	}

}

export default (new RecentArticlesModal);
