import BSModal from "../../../_external/bootstrap/modal.js";
import ProjectTagRow from "../components/ProjectTagRow.js";
import PageEditorStates from "../PageEditorStates.js";

class ProjectTagsManageModal{
	constructor(){

		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.modal = document.querySelector("#manage-project-tags-modal");
		this.enableNewProjectTagForm = this.modal.querySelector("#new-project-tag-form");
		this.cancelNewProjectTagFormButton = document.querySelector("#cancel-new-project-tag-button");
		this.enableNewProjectTagFormButton = this.modal.querySelector("#enable-new-project-tag-form");
		this.enableNewProjectTagFormButtonContainer = this.modal.querySelector("#enable-new-project-tag-button-container");
		this.bsModal = new BSModal(this.modal);

		const systemProjectTagsInitElement = document.querySelector("#init-all-system-project-tags");
		const pageProjectTagsInitElement = document.querySelector("#init-page-project-tags");

		// Preload the project tag selection rows
		let systemProjectTags = [];
		let pageProjectTags = [];

		try {
			systemProjectTags = JSON.parse(systemProjectTagsInitElement.value);
		}catch(e){}

		try {
			pageProjectTags = JSON.parse(pageProjectTagsInitElement.value);
		}catch(e){}

		systemProjectTags.sort((a, b) => a.label.localeCompare(b.label));

		// Fix overlapping imports not completing and accessing ProjectTagRow before import finishes
		setTimeout(() => {
			for (/** @type {{id: int, label: string}} */ const projectTag of systemProjectTags) {
				// Check if it is selected on this page
				let isSelected = false;
				for (/** @type {{id: int, pageID: number, projectTagID: number}} */ const pageProjectTag of pageProjectTags) {
					if (pageProjectTag.projectTagID === projectTag.id) {
						isSelected = true;
					}
				}
				new ProjectTagRow(projectTag.id, projectTag.label, isSelected);
			}
		}, 1);

		this.enableNewProjectTagFormButton.addEventListener("click", () => {
			this.showNewProjectTagForm();
		});

		this.cancelNewProjectTagFormButton.addEventListener("click", () => {
			this.hideNewProjectTagForm();
		});
	}

	showNewProjectTagForm(){
		this.enableNewProjectTagForm.style.display = "block";
		this.enableNewProjectTagFormButtonContainer.style.display = "none";
	}

	hideNewProjectTagForm(){
		this.enableNewProjectTagForm.style.display = "none";
		this.enableNewProjectTagFormButtonContainer.style.display = "block";
	}

	/**
	* Forces the modal to be shown
	*/
	showModal(){
		this.bsModal.show();
	}

	/**
	* Forces the modal to be hidden
	*/
	hideModal(){
		this.bsModal.hide();
	}
}

export default new ProjectTagsManageModal();
