import BSModal from "../../../_external/bootstrap/modal.js";
import PageEditorStates from "../PageEditorStates.js";

class BlogReelModal{
	constructor(){

		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.modal = document.querySelector("#blog-reel-modal");
		this.bsModal = new BSModal(this.modal);

		this.inclusionButtons = this.modal.querySelectorAll(".blog-reel-category-include-button");
		this.exclusionButtons = this.modal.querySelectorAll(".blog-reel-category-exclude-button");

		for (let button of this.inclusionButtons){
			button.addEventListener("click", () => {
				this.onIncludeCategoryButtonClicked(button);
			});
		}

		for (let button of this.exclusionButtons){
			button.addEventListener("click", () => {
				this.onExcludeCategoryButtonClicked(button);
			});
		}
	}

	/**
	* Forces the modal to be shown
	*/
	showModal(){
		this.bsModal.show();
	}

	/**
	* Forces the modal to be hidden
	*/
	hideModal(){
		this.bsModal.hide();
	}

	/**
	* An include-category button was clicked
	* @param {HTMLButtonElement} button
	*/
	onIncludeCategoryButtonClicked(button){
		if (!button.classList.contains("selected")){
			button.classList.add("btn-primary");
			button.classList.add("selected");
			button.classList.remove("btn-outline-primary");
		}else{
			button.classList.add("btn-outline-primary");
			button.classList.remove("selected");
			button.classList.remove("btn-primary");
		}
	}

	/**
	* An exclude-category button was clicked
	* @param {HTMLButtonElement} button
	*/
	onExcludeCategoryButtonClicked(button){
		if (!button.classList.contains("selected")){
			button.classList.add("btn-danger");
			button.classList.add("selected");
			button.classList.remove("btn-outline-danger");
		}else{
			button.classList.add("btn-outline-danger");
			button.classList.remove("selected");
			button.classList.remove("btn-danger");
		}
	}
}

export default new BlogReelModal();
