import PageEditorStates from "../PageEditorStates.js";
import Endpoints from "../../../Endpoints.js";

class NewPageForm{
	constructor(){
		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.form = document.querySelector("#new-page-form");

		/** @property {bool} isSubmitting The current status of submission */
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	/**
	* When the form is submitted
	*/
	async onSubmit(){
		const fData = new FormData(this.form);
		const submitButton = this.form.querySelector(`button[type="submit"]`);
		const errorContainer = this.form.querySelector(".submit-error");

		if (this.isSubmitting){
			return;
		}

		// Show the submit button as disabled
		submitButton.classList.add("disabled");
		errorContainer.style.display = "none";

		const response = await fetch(Endpoints.pageEditor.createBlankPage, {
			cache:"no-cache",
			method:"post",
			credentials:"same-origin",
			body:fData
		});

		/** @type {{status: int, error: ?string, newPage: Object}} */
		const data = await response.json();

		if (data.status === 1){
			if ("id" in data.newPage) {
				this.onSuccess(data.newPage.id);
			}
		}else if (data.status === -1){
			this.onFormattedError(data.error);
		}
	}

	/**
	 * When the form receives a success message from the server
	 * (A status of 1 was read)
	 * @param {int} pageID
	*/
	onSuccess(pageID){
		window.location.href = `${Endpoints.pageEditor.editor}/${pageID}`
	}

	/**
	* A readable error happened on the server in the JSON response.
	* (A status of -1 was read)
	* @param {string} err
	*/
	onFormattedError(err){
		const errorContainer = this.form.querySelector(".submit-error");
		const submitButton = this.form.querySelector(`button[type="submit"]`);

		this.isSubmitting = false;
		submitButton.classList.remove("disabled");
		errorContainer.textContent = err;
		errorContainer.style.display = "block";
	}
}

export default new NewPageForm();
