import GetPagesCheckboxes from "../components/GetPagesCheckboxes.js";

class FilterGetPagesResultsForm{

	form = document.querySelector("#filter-get-pages-results-form");
	input = document.querySelector("#query-get-pages-results");
	isSubmitting = false;

	constructor(){
		if(this.input !== null){
			this.input.addEventListener("input", e => {
				e.preventDefault();
				this.onSubmit();
			});
		}
	}

	/**
	* When the form is submitted
	*/
	async onSubmit(){
		const inputValue = this.input.value.toLowerCase();

		for (const getPagesCheckbox of GetPagesCheckboxes.rows){
			if (inputValue.trim() !== ""){
				if (getPagesCheckbox.pageName.toLowerCase().includes(inputValue)){
					getPagesCheckbox.dom.style.display = null;
				}else{
					getPagesCheckbox.dom.style.display = "none";
				}
			}else{
				// Show all
				getPagesCheckbox.dom.style.display = null;
			}
		}
	}
}

export default (new FilterGetPagesResultsForm);
