import PageEditorStates from "../PageEditorStates.js";
import Endpoints from "../../../Endpoints.js";

class DeletePageForm{
	constructor(){
		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.form = document.querySelector("#delete-page-form");

		/** @property {bool} isSubmitting The current status of submission */
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	/**
	* When the form is submitted
	*/
	async onSubmit(){
		const submitButton = this.form.querySelector(`button[type="submit"]`);
		const errorContainer = this.form.querySelector(".submit-error");

		if (this.isSubmitting){
			return;
		}

		// Show the submit button as disabled
		submitButton.classList.add("disabled");
		errorContainer.style.display = "none";

		const response = await fetch(`/uplift/page-editor/page/${PageEditorStates.currentPageID}`, {
			cache:"no-cache",
			method:"delete",
			credentials:"same-origin",
		});

		/** @type {{status: int, error: ?string}} */
		const data = await response.json();

		if (data.status === 1){
			this.onSuccess();
		}else if (data.status === -1){
			this.onFormattedError(data.error);
		}
	}

	/**
	* When the form receives a success message from the server
	* (A status of 1 was read)
	*/
	onSuccess(){
		window.location.href = Endpoints.pageEditor.editor;
	}

	/**
	* A readable error happened on the server in the JSON response.
	* (A status of -1 was read)
	* @param {string} err
	*/
	onFormattedError(err){
		const errorContainer = this.form.querySelector(".submit-error");

		this.isSubmitting = false;
		errorContainer.textContent = err;
		errorContainer.style.display = "block";
	}
}

export default (new DeletePageForm);
