import PageEditor from "../PageEditor.js";
import Scheduler from "../../../utils/Scheduler.js";

class RestoreRevisionButton{
	isProcessing = false;
	button = document.querySelector("#restore-revision-button");

	constructor() {
		this.button.addEventListener("click", () => {
			this.onClick();
		});
	}

	async onClick(){

		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		PageEditor.hidePageEditor();
		PageEditor.showPageEditorLoader();

		const idsFromURL = PageEditor.getPageIDAndRevisionIDFromURL();

		const response = await fetch(`/uplift/page-editor/revisions/${idsFromURL.pageID}/${idsFromURL.revisionID}/restore`, {
		    method:"POST",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
		    /** @type {{status: int, error: ?string}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
		    return;
		}

		await Scheduler.wait(500);

		if (data.status === 1){
			// If restored successfully, then redirect to the page editor
			window.location.href = `/uplift/page-editor/${idsFromURL.pageID}`;
		}else if (data.status === -1){
			alert(data.error);
			PageEditor.showPageEditor();
			PageEditor.hidePageEditorLoader();
		}

		this.isProcessing = false;
	}

	show(){
		this.button.style.display = null;
	}

	hide(){
		this.button.style.display = "none";
	}
}

export default new RestoreRevisionButton();