class PageList{

	/** @type {PageList[]} */
	static instances = [];
	static categoriesSidebarContainer = document.querySelector("page-categories-sidebar");

	dom;
	categoryName;

	/**
	 * @param {string} categoryName The page type
	 * @returns {PageList|null}
	 */
	static getByCategoryName(categoryName){
		for (const pageList of PageList.instances){
			if (pageList.categoryName === categoryName){
				return pageList;
			}
		}

		return null;
	}

	static hide(){
		PageList.categoriesSidebarContainer.style.display = "none";
		for (const pageList of PageList.instances){
			pageList.dom.style.display = "none";
		}
	}

	/**
	 *
	 * @param {HTMLElement} container
	 */
	constructor(container){
		this.dom = container;
		this.categoryName = container.getAttribute("data-page-category");

		PageList.instances.push(this);
	}

	show(){
		PageList.categoriesSidebarContainer.style.display = "flex";
		this.dom.style.display = "block";
	}
}

export default PageList;