class GetPagesCheckboxes{

	/** @type {GetPagesCheckboxes[]} */
	static rows = [];

	/** @type {HTMLDivElement} */
	static blogContainer = document.querySelector("#get-pages-blog-tab-pane");
	static cityContainer = document.querySelector("#get-pages-city-tab-pane");
	static generalContainer = document.querySelector("#get-pages-general-tab-pane");
	static projectContainer = document.querySelector("#get-pages-project-tab-pane");
	static serviceContainer = document.querySelector("#get-pages-service-tab-pane");

	/**
	 * Removes all the DOM HTML of each button and then clears the static rows array
	 */
	static clearAll(){
		for (const component of GetPagesCheckboxes.rows){
			component.dom.remove();
		}

		GetPagesCheckboxes.rows = [];
	}

	/**
	 * @type {boolean} Whether this button is selected or not
	 */
	isSelected = false;
	pageID;
	pageName;
	pageType;
	dom;

	constructor(pageID, pageName, pageType) {
		this.pageID = pageID;
		this.pageName = pageName;
		this.pageType = pageType;
		this.dom = this.getDOM();

		this.constructor.rows.push(this);

		if(this.pageType === "Blog") {
			this.constructor.blogContainer.append(this.dom);
		} else if(this.pageType === "City") {
			this.constructor.cityContainer.append(this.dom);
		} else if(this.pageType === "General") {
			this.constructor.generalContainer.append(this.dom);
		} else if(this.pageType === "Project") {
			this.constructor.projectContainer.append(this.dom);
		} else if(this.pageType === "Service") {
			this.constructor.serviceContainer.append(this.dom);
		}
	}

	getDOM(){
		const template = document.createElement("div");
		template.classList.add("form-check");
		template.innerHTML = `
			<input id="get-pages-checkbox-for-page-id-${this.pageID}" class="form-check-input" name="pages[]" type="checkbox" value="${this.pageID}">
			<label for="get-pages-checkbox-for-page-id-${this.pageID}" class="form-check-label">${this.pageName}</label>
		`;

		return template;
	}

}

export default GetPagesCheckboxes;