import AddAttributeModal from "../modals/AddAttributeModal.js";

class AvailableAttributeItem{

	/** @type {AvailableAttributeItem[]} */
	static cache = [];
	static container = document.querySelector("#available-attributes-container");

	static clearAll(){
		AvailableAttributeItem.cache = [];
		AvailableAttributeItem.container.innerHTML = "";
	}

	id;
	name;
	dom;

	constructor(id, name) {
		this.id = id;
		this.name = name;
		this.dom = this.getDOM();
		this.constructor.cache.push(this);
	}

	render(){
		AvailableAttributeItem.container.append(this.dom);
	}

	getDOM(){
		const template = document.createElement("div");
		template.classList.add("available-attribute-item");
		template.innerHTML = `
			<div class="name-column">
				<span>${this.name}</span>
			</div>
			<div class="buttons-column">
				<button type="button" class="btn btn-sm btn-primary">
					<span>Select</span>
				</button>
			</div>
		`;

		const button = template.querySelector("button");

		button.addEventListener("click", () => {
			AddAttributeModal.onAvailableAttributeClicked(this);
		});

		return template;
	}
}

export default AvailableAttributeItem;