import PageEditorStates from "./PageEditorStates.js";

class SidebarPageNameFilter{
	constructor(){

		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.input = document.querySelector("#page-name-search");
		this.input.addEventListener("input", () => {
			this.filterPages(this.input.value);
		});
	}

	/**
	* Shows or hides matching page names
	*/
	filterPages(text){
		const loweredInput = text.toLowerCase().trim();
		const pageButtons = document.querySelectorAll(".page-list-page-button");

		for (let button of pageButtons){
			const pageNameSpan = button.querySelector("span");
			const pageName = pageNameSpan.textContent.trim().toLowerCase();
			if (pageName.includes(loweredInput)){
				button.style.display = "flex";
			}else{
				button.style.display = "none";
			}
		}
	}
}

export default (new SidebarPageNameFilter);
