/**
 * Responsible for loading the current page's revision archives and data into the editor
 */
import PageContentLoader from "./PageContentLoader.js";
import PageEditorStates from "./PageEditorStates.js";

class RevisionLoader{
	/**
	 * Fetch the data of the page revision, the render it into view
	 * @param {PageEditor} pageEditor Needed because initialization isn't finished yet
	 * @param {int} pageID
	 * @param {int} revisionID
	 */
	async loadRevision(pageEditor, pageID, revisionID){
		pageEditor.showPageEditorLoader();
		PageEditorStates.isLoadingPage = true;
		const response = await fetch(`/uplift/page-editor/page/${pageID}/revision/${revisionID}`, {
		    method:"GET",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
		    /** @type {{status: int, error: ?string, page: Object, data: Object[], breadcrumbs: Object[], pageContentSections: Object[]}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
		    return;
		}

		let sectionDefinitionForLayout = null;
		try{
			sectionDefinitionForLayout = await pageEditor.getSectionDefinitionForLayoutName(data.page.pageLayout);
		}catch(ex){}

		PageEditorStates.currentPageLayoutSectionDefinition = sectionDefinitionForLayout;

		if (data.status === 1){
			PageContentLoader.loadPage(data.page, data.pageContentSections, sectionDefinitionForLayout);
			PageContentLoader.loadPageBreadcrumbs(data.breadcrumbs);
			PageContentLoader.loadPageData(data.page, data.data);
			pageEditor.hidePageEditorLoader();
			pageEditor.showPageEditor();
			pageEditor.showHideCorrectBodyEditorIfVisibleForCurrentLayoutSectionDefinition();
			pageEditor.toggleAllFieldsReadOnly(true);
			PageEditorStates.isLoadingPage = false;
		}else if (data.status === -1){

		}
	}
}

export default new RevisionLoader();