/**
 * Keeps track of the selected project tag IDs
 */
import ProjectTagRow from "./components/ProjectTagRow.js";
import ProjectTagPageDataLabel from "./components/ProjectTagPageDataLabel.js";
import PageEditorStates from "./PageEditorStates.js";
import ContentChangedHandler from "../ContentChangedHandler.js";

class ProjectTagManager{
	/** @type {number[]} */
	selectedProjectTagIDs = [];
	noTagsMessageContainer = document.querySelector("#no-project-tags-message");
	labelsContainer = document.querySelector("#project-tags-labels");

	refreshEditorDisplayOfTags(){
		if (this.selectedProjectTagIDs.length === 0){
			this.noTagsMessageContainer.style.display = null;
			this.labelsContainer.innerHTML = ``;
			ProjectTagPageDataLabel.clearAll();
		}else{
			this.noTagsMessageContainer.style.display = "none";
		}
	}

	/**
	 * Stores a project tag ID as having been selected
	 * @param tagID
	 */
	addTagIDToSelected(tagID){
		if (this.selectedProjectTagIDs.indexOf(tagID) === -1){
			ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
			const tagName = ProjectTagRow.getProjectTagByTagID(tagID).tagLabel;
			new ProjectTagPageDataLabel(tagID, tagName);
			this.selectedProjectTagIDs.push(tagID);
			this.refreshEditorDisplayOfTags();
		}
	}

	/**
	 * Deselects a project tag ID
	 * @param tagID
	 */
	removeTagIDFromSelected(tagID){
		const index = this.selectedProjectTagIDs.indexOf(tagID)
		if (index !== -1){
			ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
			this.selectedProjectTagIDs.splice(index, 1);
			this.refreshEditorDisplayOfTags();
			ProjectTagPageDataLabel.removeRowByID(tagID);
		}
	}

	/**
	 * Clears the current project tag ID selection
	 */
	clearSelectedTagIDs(){
		this.selectedProjectTagIDs = [];
		this.refreshEditorDisplayOfTags();
	}
}

export default new ProjectTagManager();