import ArticleCategoryPageDataLabel from "./components/ArticleCategoryPageDataLabel.js";
import ArticleCategoryRow from "./components/ArticleCategoryRow.js";
import PageEditorStates from "./PageEditorStates.js";
import ContentChangedHandler from "../ContentChangedHandler.js";

/**
 * Keeps track of the selected article categories
 */
class ArticleCategoryManager{
	/** @type {number[]} */
	selectedArticleCategories = [];
	noSelectionMessageContainer = document.querySelector("#no-article-category-message");
	labelsContainer = document.querySelector("#article-categories-labels");

	/**
	 * Refreshes the labels on the Page Data tab of the editor, or shows the "no categories" message.
	 */
	refreshEditorDisplayOfCategories(){
		if (this.selectedArticleCategories.length === 0){
			this.noSelectionMessageContainer.style.display = null;
			this.labelsContainer.innerHTML = ``;
			ArticleCategoryPageDataLabel.clearAll();
		}else{
			this.noSelectionMessageContainer.style.display = "none";
		}
	}

	/**
	 * Stores a category ID as having been selected
	 * @param {int} categoryID
	 */
	addCategoryToSelected(categoryID){
		if (this.selectedArticleCategories.indexOf(categoryID) === -1){
			ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
			const categoryName = ArticleCategoryRow.getByArticleCategoryID(categoryID).articleCategoryName;
			new ArticleCategoryPageDataLabel(categoryID, categoryName);
			this.selectedArticleCategories.push(categoryID);
			this.refreshEditorDisplayOfCategories();
		}
	}

	/**
	 * Deselects an article category
	 * @param categoryID
	 */
	removeCategoryFromSelected(categoryID){
		const index = this.selectedArticleCategories.indexOf(categoryID)
		if (index !== -1){
			ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
			this.selectedArticleCategories.splice(index, 1);
			this.refreshEditorDisplayOfCategories();
			ArticleCategoryPageDataLabel.removeRowByID(categoryID);
		}
	}

	/**
	 * Clears the current category selection
	 */
	clearSelectedCategories(){
		this.selectedArticleCategories = [];
		this.refreshEditorDisplayOfCategories();
	}
}

export default new ArticleCategoryManager();