import FileEditorWrapper from "../FileEditorWrapper.js";

class PureCompanyPhoneNumbersPHPVariableButton{
	constructor(){
		/** @type {HTMLButtonElement[]} */
		this.innerButtons = document.querySelectorAll(".pure-company-phone-php-var-button");

		for (let button of this.innerButtons){
			button.addEventListener("click", () => {
				this.onInnerButtonClicked(button);
			});
		}
	}

	/**
	* When one of the dropdown buttons for the PHP variable is clicked
	* @param {HTMLButtonElement} button
	*/
	onInnerButtonClicked(button){
		const numberIndex = button.getAttribute("data-index");
		const outputText = `<?= \\System\\PhoneNumberUtility::getPurePhoneNumber($phoneNumbers[${numberIndex}]) ?>`;
		FileEditorWrapper.insertTextAtCursor(outputText);
		FileEditorWrapper.focusEditor();
	}
}

export default new PureCompanyPhoneNumbersPHPVariableButton();
