import FileEditorWrapper from "../FileEditorWrapper.js";

class CompanyPhoneNumbersPHPVariableButton{
	constructor(){
		this.innerButtons = document.querySelectorAll(".company-phone-php-var-button");

		for (let button of this.innerButtons){
			button.addEventListener("click", () => {
				this.onInnerButtonClicked(button);
			});
		}
	}

	/**
	* When one of the dropdown buttons for the PHP variable is clicked
	* @param {DOMNode} button
	*/
	onInnerButtonClicked(button){
		const numberIndex = button.getAttribute("data-index");
		const outputText = `<?= $phoneNumbers[${numberIndex}] ?>`;
		FileEditorWrapper.insertTextAtCursor(outputText);
		FileEditorWrapper.focusEditor();
	}
}

export default (new CompanyPhoneNumbersPHPVariableButton);
