import FileEditorWrapper from "../FileEditorWrapper.js";

class CompanyFaxNumbersPHPVariableButton{
	constructor(){
		this.innerButtons = document.querySelectorAll(".company-fax-php-var-button");

		for (let button of this.innerButtons){
			button.addEventListener("click", () => {
				this.onInnerButtonClicked(button);
			});
		}
	}

	/**
	* When one of the dropdown buttons for the PHP variable is clicked
	* @param {DOMNode} button
	*/
	onInnerButtonClicked(button){
		const numberIndex = button.getAttribute("data-index");
		const outputText = `<?= $faxNumbers[${numberIndex}] ?>`;
		FileEditorWrapper.insertTextAtCursor(outputText);
		FileEditorWrapper.focusEditor();
	}
}

export default (new CompanyFaxNumbersPHPVariableButton);
