import ConfirmModal from "../../../utils/ConfirmModal.js";
import Endpoints from "../../../Endpoints.js";

class DeleteFileMechanic{
	/**
	* @param {string} filePath
	* @param {HTMLDivElement} fileContainerNode (Optional) Containing DOM node for the file in the file editor sidebar
	*/
	async deleteFile(filePath, fileContainerNode){
		const confirmModal = new ConfirmModal("delete-file-confirm-modal");
		confirmModal.setTitle("Confirm file deletion");
		confirmModal.setContent(`This file will be deleted forever.`);
		confirmModal.setConfirmButtonText(`Confirm Deletion`);
		confirmModal.showModal();

		const confirmed = await confirmModal.actionTaken();
		confirmModal.hideModal();
		confirmModal.modal.remove();
		if (confirmed){
			const fData = new FormData();

			// Hide it for now. Remove it if the endpoint tells us it didn't error
			if (fileContainerNode){
				fileContainerNode.style.display = "none";
			}

			fData.append("file-path", filePath);
			const response = await fetch(`/uplift/theme-manager/file`, {
				credentials:"same-origin",
				cache:"no-cache",
				method:"DELETE",
				body:fData
			});

			/** @type {{status: int, error: ?string}} */
			const data = await response.json();

			if (data.status === -1){
				// Error, put the directory back into view
				if (fileContainerNode){
					fileContainerNode.style.display = "block";
				}
			}else if (data.status === 1){
				// No error, remove it from the DOM
				if (fileContainerNode){
					fileContainerNode.remove();
				}
			}
		}
	}
}

export default (new DeleteFileMechanic);
