import ConfirmModal from "../../../utils/ConfirmModal.js";
import Endpoints from "../../../Endpoints.js";

class DeleteDirectoryMechanic{
	/**
	* @param {string} dirLocation
	* @param {HTMLDivElement} directoryContainerNode (Optional) Containing DOM node for the directory in the file editor sidebar
	*/
	async deleteDirectory(dirLocation, directoryContainerNode){
		const confirmModal = new ConfirmModal("delete-directory-confirm-modal");
		confirmModal.setTitle("Confirm directory deletion");
		confirmModal.setContent(`All of the directory's contents and sub-folders will be deleted forever.`);
		confirmModal.setConfirmButtonText(`Confirm Deletion`);
		confirmModal.showModal();

		const confirmed = await confirmModal.actionTaken();
		confirmModal.hideModal();
		confirmModal.modal.remove();
		if (confirmed){
			const fData = new FormData();

			// Hide it for now. Remove it if the endpoint tells us it didn't error
			if (directoryContainerNode){
				directoryContainerNode.style.display = "none";
			}

			fData.append("directory", dirLocation);
			const response = await fetch(`/uplift/theme-manager/directory`, {
				credentials:"same-origin",
				cache:"no-cache",
				method:"delete",
				body:fData
			});

			/** @type {{status: int, error: ?string}} */
			const data = await response.json();

			if (data.status === -1){
				// Error, put the directory back into view
				if (directoryContainerNode){
					directoryContainerNode.style.display = "block";
				}
			}else if (data.status === 1){
				// No error, remove it from the DOM
				if (directoryContainerNode){
					directoryContainerNode.remove();
				}
			}
		}
	}
}

export default (new DeleteDirectoryMechanic);
