import ConfirmModal from "../../../utils/ConfirmModal.js";
import SidebarFileLoader from "../SidebarFileLoader.js";
import FileEditorStates from "../FileEditorStates.js";
import Endpoints from "../../../Endpoints.js";

class CompileSCSSMechanics{

	overlaysContainer = document.querySelector("#content-editor-sidebar-overlays-container");

	constructor(){
		this.compilingLoader = document.querySelector("#compiling-scss-overlay");
	}

	/**
	* @param {string} filePath
	*/
	async compileFile(filePath){
		this.overlaysContainer.classList.add("active");
		this.compilingLoader.style.display = null;

		const fData = new FormData();
		fData.append("file-path", filePath);

		const response = await fetch(`/uplift/theme-manager/compile-scss-file`, {
			credentials:"same-origin",
			cache:"no-cache",
			body:fData,
			method:"POST"
		});

		/** @type {{status: int, error: ?string}} */
		const data = await response.json();

		this.overlaysContainer.classList.remove("active");
		this.compilingLoader.style.display = "none";
		if (data.status === 1){
			SidebarFileLoader.loadDirectory(FileEditorStates.rootThemeDirectory + FileEditorStates.currentDirectory);
		}else if (data.status === -1){
			const modal = new ConfirmModal("scss-compile-error-modal");
			modal.setTitle("Compilation error");
			modal.hideSecondaryButton();
			modal.setConfirmButtonText("Okay");
			modal.setHTMLContent(`
				<p>
					There was an error while compiling the selected SCSS file. Please read below.
				</p>
				<div>
					<pre>${data.error}</pre>
				</div>
			`);
			modal.showModal();
			await modal.actionTaken();
			modal.cleanup();
		}
	}
}

export default (new CompileSCSSMechanics);
