import NewDirectoryModal from "../modals/NewDirectoryModal.js";
import FileEditorStates from "../FileEditorStates.js";
import SidebarFileLoader from "../SidebarFileLoader.js";
import Utils from "../Utils.js";

class NewDirectoryForm{
	constructor(){
		this.form = document.querySelector("#new-directory-form");

		/** @property {bool} isSubmitting The current status of submission */
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	/**
	* When the form is submitted
	*/
	async onSubmit(){
		const fData = new FormData(this.form);
		const submitButton = this.form.querySelector(`button[type="submit"]`);
		const errorContainer = this.form.querySelector(".submit-error");

		if (this.isSubmitting){
			return;
		}

		let parentDirectory = `${FileEditorStates.rootThemeDirectory}`;
		if (FileEditorStates.currentDirectory !== "/"){
			parentDirectory += FileEditorStates.currentDirectory;
		}
		fData.append("parent-directory", parentDirectory);

		// Show the submit button as disabled
		submitButton.classList.add("disabled");
		errorContainer.style.display = "none";

		const response = await fetch(`/uplift/theme-manager/directory`, {
			credentials:"same-origin",
			cache:"no-cache",
			method:"post",
			body:fData
		});

		/** @type {{error: ?string, status: int}} */
		const data = await response.json();

		if (data.status === 1){
			this.onSuccess();
		}else if (data.status === -1){
			this.onFormattedError(data.error);
		}
	}

	/**
	* When the form succeeds without error
	*/
	onSuccess(){
		const submitButton = this.form.querySelector(`button[type="submit"]`);
		this.isSubmitting = false;
		submitButton.classList.remove("disabled");
		SidebarFileLoader.loadDirectory(Utils.getFullPathFromRelativeThemePath(FileEditorStates.currentDirectory));
		NewDirectoryModal.hideModal();
	}

	/**
	* A readable error happened on the server in the JSON response.
	* (A status of -1 was read)
	* @param {string} err
	*/
	onFormattedError(err){
		const errorContainer = this.form.querySelector(".submit-error");
		const submitButton = this.form.querySelector(`button[type="submit"]`);

		this.isSubmitting = false;
		submitButton.classList.remove("disabled");
		errorContainer.textContent = err;
		errorContainer.style.display = "block";
	}
}

export default (new NewDirectoryForm);
