export class FilePathUtility{
	/**
	 * The, OS-specific, full directory path of the current theme
	 * @type {string}
	 */
	static currentThemeDirectory = document.querySelector("#current-theme-directory-path").value;

	/**
	 * Determines if a provided full-file-path is part of the theme's layout files
	 * @param filePath
	 * @return boolean
	 */
	static isFileLayoutFile(filePath){
		// Replace all backslashes with forward slashes
		filePath = filePath.replaceAll("\\", "/");
		const transformedCurrentThemeDirectoryPath = this.currentThemeDirectory.replaceAll("\\", "/");

		// Get the relative, from the current theme, file path
		const relativeFilePath = filePath.replace(transformedCurrentThemeDirectoryPath, "");

		return relativeFilePath.startsWith("/layouts");
	}

	/**
	 * Gets just the file name from a filePath
	 * @param filePath
	 */
	static getFileName(filePath){
		return filePath.split('\\').pop().split('/').pop();
	}
}