class FileEditorStates{
	constructor(){

		/** @type {boolean} */
		this.unsavedChanges = false;

		/** @type {?string} The root directory the Uplift application is being served from. */
		this.applicationRoot = null;

		/** @type {string} This property should never update */
		this.rootThemeDirectory = document.querySelector("#theme-root-directory").value;

		/** @type {string} Relative path */
		this.currentDirectory = document.querySelector("#directory-location-input").value;

		/** @type {string} Of the current open and active file */
		this.currentFilePath = "";

		/** @type {string[]} The history of locations the user has navigated */
		this.directoryLocationHistory = [];

		/** @type {?ContextMenu} */
		this.currentContextMenu = null;

	}

	/**
	* Removes a location entirely from the tracked directory history
	* @param {string} directoryLocation
	*/
	removeLocationFromHistory(directoryLocation){
		while (this.directoryLocationHistory.indexOf(directoryLocation) > -1){
			this.directoryLocationHistory.splice(this.directoryLocationHistory.indexOf(directoryLocation), 1);
		}
	}
}

export default (new FileEditorStates);
