import FileEditorStates from "./FileEditorStates.js";
import SidebarFileLoader from "./SidebarFileLoader.js";
import Utils from "./Utils.js";

class DragImportHandler{
	constructor(){
		this.container = document.querySelector("#content-editor-page-navigation-column");
		this.overlay = document.querySelector("#import-drag-over-window");
		this.uploadingOverlay = document.querySelector("#importing-status-overlay");
		this.readingStatus = document.querySelector("#import-status-read-status");
		this.uploadingStatus = document.querySelector("#import-status-upload-status");
		this.dragEventCounter = 0; // To keep track of the bubble of events. Otherwise it repeatedly bubbles and fires over and over

		this.container.addEventListener("dragover", e => {
			e.preventDefault();
		});

		this.container.addEventListener("dragenter", e => {
			e.preventDefault();
			++this.dragEventCounter;
			this.overlay.style.display = "block";
		});

		this.container.addEventListener("dragleave", e => {
			e.preventDefault();
			--this.dragEventCounter;

			// Has it "dragleave"'d out of all children?
			if (this.dragEventCounter === 0){
				this.overlay.style.display = "none";
			}
		});

		this.container.addEventListener("drop", async e => {
			e.stopPropagation();
			e.preventDefault();
			this.overlay.style.display = "none";
			this.uploadingStatus.style.display = "none";
			this.readingStatus.style.display = "block";
			const files = e.dataTransfer.files;
			if (files.length > 0){

				// Create the correct full upload directory
				let parentDirectory = `${FileEditorStates.rootThemeDirectory}`;
				if (FileEditorStates.currentDirectory !== "/"){
					parentDirectory += FileEditorStates.currentDirectory;
				}

				document.querySelector("#drag-upload-max").textContent = String(files.length);
				document.querySelector("#drag-upload-current").textContent = "0";
				this.uploadingOverlay.style.display = "block";
				let filesUploaded = 0;
				for (let file of files){
					let isDirectory = false;
					await new Promise(resolve => {
						const fReader = new FileReader();
						fReader.onloadend = async () => {
							if (fReader.error && file.type === "") {
								// Can't handle this, it is probably a directory
								isDirectory = true;
							}else{
								// This is a file, and it can be handled fine
								const fData = new FormData();
								fData.append("parent-directory", parentDirectory);
								fData.append(`file-name`, file.name);
								fData.append(`file-contents`, new Blob([fReader.result], { type: file.type}));

								// Post it
								const response = await fetch(`/uplift/theme-manager/file`, {
									cache:"no-cache",
									credentials:"same-origin",
									body:fData,
									method:"POST"
								});

								if (response.status === 200){
									/** @type {{status: int, error: ?string}} */
									const data = await response.json();
									if (data.status === 1){

									}else if (data.status === -1){
										console.warn(data.error);
									}

									// Either way...
									resolve();
								}
							}
						}

						fReader.onerror = err => {
							console.warn(err);
							resolve();
						}

						fReader.readAsArrayBuffer(file);
					});

					document.querySelector("#drag-upload-current").textContent = String(++filesUploaded);
				}

				this.uploadingOverlay.style.display = "none";
				await SidebarFileLoader.loadDirectory(Utils.getFullPathFromRelativeThemePath(FileEditorStates.currentDirectory));
			}else{
				// nothing was dropped that was useful
				console.log("No files were dropped. Dragging images, text, or HTML is not supported.");
			}
		});
	}
}

export default (new DragImportHandler)
