import EasyEditorManager from "../EasyEditorManager.js";

export default class SidebarPageItem{
	ActivePageId;
	Container;
	DOM;
	PageName;
	PageId;

	constructor(container, pageName, pageId, activePageId, easyEditorInstance) {
		this.Container = container;
		this.ActivePageId = activePageId;
		this.PageName = pageName;
		this.PageId = pageId;
		this.DOM = this.BuildDOM(easyEditorInstance);
		this.Container.append(this.DOM);
	}

	BuildDOM(easyEditorInstance){
		const template = document.createElement("button");
		template.classList.add("page-list-page-button");
		template.setAttribute("type", "button");
		template.setAttribute("title", this.PageName);
		template.setAttribute("data-bs-toggle", "tooltip");

		const buttonColumns = document.createElement("span");
		buttonColumns.classList.add("button-columns");

		const activeButtonColumn = document.createElement("span");
		activeButtonColumn.classList.add("active-button-column");

		const activeButtonIndicator = document.createElement("span");
		activeButtonIndicator.classList.add("active-button-indicator");
		activeButtonIndicator.innerHTML = '<i class="bi bi-arrow-bar-right"></i>';

		activeButtonColumn.appendChild(activeButtonIndicator);
		buttonColumns.appendChild(activeButtonColumn);

		const buttonLabelColumn = document.createElement("span");
		buttonLabelColumn.classList.add("button-label-column");

		const pageLabelIconSpan = document.createElement("span");
		pageLabelIconSpan.classList.add("page-label-icon-span");
		pageLabelIconSpan.innerHTML = '<i class="bi bi-file-break-fill"></i>';

		const pageLabelSpan = document.createElement("span");
		pageLabelSpan.classList.add("page-label-span");
		pageLabelSpan.textContent = this.PageName;

		buttonLabelColumn.appendChild(pageLabelIconSpan);
		buttonLabelColumn.appendChild(pageLabelSpan);
		buttonColumns.appendChild(buttonLabelColumn);

		template.appendChild(buttonColumns);

		if(this.PageId === this.ActivePageId) {
			template.classList.add("active-page");
		}

		template.addEventListener("click", async () => {
			await EasyEditorManager.LoadPage(this.PageId);

			this.RemoveActivePageClassFromButtons();
			template.classList.add("active-page");
		})

		return template;
	}

	RemoveActivePageClassFromButtons() {
		let pageListPageButtons = document.querySelectorAll(".page-list-page-button");

		for(const pageListPageButton of pageListPageButtons){
			pageListPageButton.classList.remove("active-page");
		}
	}
}