import Endpoints from "../../Endpoints.js";
import SidebarPageItem from "./components/SidebarPageItem.js";

export default class EditorSidebar {
	CategorySidebar = document.querySelector("#pages-categories-main");
	PageSidebar = document.querySelector("page-categories-sidebar");
	PageSidebarTitle = this.PageSidebar.querySelector(".page-type-title");
	PageSidebarBackButton = this.PageSidebar.querySelector("#page-category-back-button");
	PageSidebarPageLists = this.PageSidebar.querySelectorAll(".page-list");
	SidebarLoader = document.querySelector("#pages-categories-loader");
	ActivePageId;

	constructor(activePageId) {
		this.ActivePageId = activePageId;
		this.Initialize();
	}

	async Initialize() {
		const pageList = await this.GetListOfPages();

		for(const pageType in pageList) {
			if(pageType === "blog"){
				this.HandleSidebarPopulation(pageList.blog, "Blog");
			} else if(pageType === "city") {
				this.HandleSidebarPopulation(pageList.city, "City");
			} else if(pageType === "general") {
				this.HandleSidebarPopulation(pageList.general, "General");
			} else if(pageType === "project") {
				this.HandleSidebarPopulation(pageList.project, "Project");
			} else if(pageType === "service") {
				this.HandleSidebarPopulation(pageList.service, "Service");
			}
		}

		this.PageSidebarBackButton.addEventListener("click", () => {
			this.PageSidebar.style.display = "none";
			this.CategorySidebar.style.display = "block";
		})

		if(this.ActivePageId === null){
			this.SidebarLoader.style.display = "none";
			this.CategorySidebar.style.display = "block";
		} else {
			const pageType = this.GetPageTypeByPageId(pageList, this.ActivePageId);
			this.PageSidebarTitle.innerHTML = pageType;

			for(const pageSidebarPageList of this.PageSidebarPageLists){
				if(pageSidebarPageList.dataset.pageCategory === pageType) {
					pageSidebarPageList.style.display = "block";
				} else {
					pageSidebarPageList.style.display = "none";
				}
			}

			this.SidebarLoader.style.display = "none";
			this.PageSidebar.style.display = "block";
		}
	}

	async GetListOfPages() {
		const response = await fetch(`${Endpoints.easyEditor.getPages}`, {
			cache:"no-cache",
			credentials:"same-origin",
			method:"get",
		});

		/** @type {{status: int, pages}} */
		let data = await response.json();
		let pages = data.pages;
		let categorizedPages = {
			blog: [],
			city: [],
			general: [],
			project: [],
			service: []
		};

		// Sort our pages into categories
		for(let page of pages) {
			if(page.pageType === "Blog") {
				categorizedPages.blog.push(page);
			} else if(page.pageType === "City") {
				categorizedPages.city.push(page);
			} else if(page.pageType === "General") {
				categorizedPages.general.push(page);
			} else if(page.pageType === "Project") {
				categorizedPages.project.push(page);
			} else if(page.pageType === "Service") {
				categorizedPages.service.push(page);
			}
		}

		// Sort pages within each category by pageName
		for (let category in categorizedPages) {
			categorizedPages[category].sort((a, b) => a.pageName.localeCompare(b.pageName));
		}

		return categorizedPages;
	}

	HandleSidebarPopulation(pageListArray, pageType){
		const categoryButton = this.CategorySidebar.querySelector('button[data-page-enum="' + pageType + '"].page-type-enum-button');

		if(categoryButton === null){
			return;
		}

		// Adjust button page count display
		categoryButton.querySelector(".num-pages").innerHTML = `${pageListArray.length}`;

		// Change title and display pages when clicked
		categoryButton.addEventListener("click", () =>{
			this.PageSidebarTitle.innerHTML = pageType;

			for(const pageSidebarPageList of this.PageSidebarPageLists){
				if(pageSidebarPageList.dataset.pageCategory === pageType) {
					pageSidebarPageList.style.display = "block";
				} else {
					pageSidebarPageList.style.display = "none";
				}
			}

			this.CategorySidebar.style.display = "none";
			this.PageSidebar.style.display = "block";
		});

		// Add pages to pageSidebar
		for(const page of pageListArray){
			new SidebarPageItem(
				document.querySelector('section.page-list[data-page-category="' + pageType + '"]'),
				page.pageName,
				page.id,
				this.ActivePageId
			);
		}
	}

	GetPageTypeByPageId(data, targetPageId) {
		for (const array in data) {
			const pagesArray = data[array];
			const page = pagesArray.find(page => page.id === targetPageId);

			if (page) {
				return page.pageType;
			}
		}

		// Page id not found in any array
		return null;
	}
}