import DOMHelper from "./DOMHelper.js";

class ContentChangedHandler{

	/**
	* When any data from the Data table in the page editor
	* is changed.
	* @param {PageEditorStates} pageEditorStates
	*/
	onPageEditorDataChanged(pageEditorStates){
		// Ignore revision changes
		if (pageEditorStates.viewType === "STANDARD") {
			// Handle the unsaved changes signal
			const editorTabs = DOMHelper.getAllPageEditorTabs();
			this.showUnsavedChangeIdentifier(editorTabs.data);
			pageEditorStates.markAsHavingUnsavedChanges();
		}
	}

	/**
	* Shows the unsaved changes identifier for the
	* provided DOM tab
	* @param {HTMLElement} tab
	*/
	showUnsavedChangeIdentifier(tab){
		tab.querySelector(".unsaved-changes").style.display = "inline-block";
	}

	/**
	* Hides all the unsaved changes identifiers
	*/
	hideAllUnsavedChangesIdentifiers(){
		for (let identifier of document.querySelectorAll(".unsaved-changes")){
			identifier.style.display = "none";
		}
	}

	/**
	* Shows the save spinners
	*/
	showSaveSpinners(){
		const spinners = document.querySelectorAll(".saving-spinner");
		for (let spinner of spinners){
			spinner.style.display = "inline-block";
		}
	}

	/**
	* Hides the save spinners
	*/
	hideSaveSpinners(){
		const spinners = document.querySelectorAll(".saving-spinner");
		for (let spinner of spinners){
			spinner.style.display = "none";
		}
	}
}

export default (new ContentChangedHandler)
