import UpdateNotification from "./components/UpdateNotification.js";

class UpdatePinger{
	async pingUpdateAPI(){
		const response = await fetch(`/uplift/updater/check-if-core-needs-updating`, {
		    method:"GET",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		if (response.status === 200){
			let data;
			try{
				/** @type {{status: int, error: ?string, message:string, needsUpdating: int}} **/
				data = await response.json();
			}catch(jsonSyntaxError){
				console.warn("The server responded with invalid JSON when pinging for an update.");
			}

			if (data.needsUpdating === 1){
				UpdateNotification.show();
			}
		}else if (response.status === 500 || response.status === 400){
			let data;
			try{
				/** @type {{status: int, error: string}} **/
				data = await response.json();
				console.warn(data.error);
			}catch(jsonSyntaxError){
				console.warn("The server responded with invalid JSON when pinging for an update.");
			}
		}

	}
}

export default new UpdatePinger();