class SearchConsoleWebsiteSelector{
	isProcessing = false;
	menu = document.querySelector("#search-console-site-select-menu");
	button = document.querySelector("#set-as-website-button");
	currentValue = this.menu.value;

	constructor() {
		this.button.addEventListener("click", () => {
			this.onClick();
		});
		this.menu.addEventListener("change", () => {
			this.onMenuChanged();
		});
	}

	onMenuChanged(){
		if (this.menu.value !== this.currentValue) {
			this.button.style.display = null;
		}else{
			this.button.style.display = "none";
		}
	}

	async onClick(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.button.classList.add("disabled");

		const fData = new FormData();
		fData.set(this.menu.getAttribute("name"), this.menu.value);
		const response = await fetch(`/uplift/settings/search-console/site`, {
			body:fData,
		    method:"PATCH",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
		    /** @type {{status: int, error: ?string, url: string}} **/
		    data = await response.json();
			this.currentValue = this.menu.value;
			this.button.style.display = "none";
			this.isProcessing = false;
			this.button.classList.remove("disabled");
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
		}
	}

}

export default new SearchConsoleWebsiteSelector();