class FilterButton{

	static types = [
		"QUERY","PAGE","DATE","COUNTRY"
	];

	/** @type {FilterButton[]} */
	static cache = [];

	static componentsContainer = document.querySelector("#filters-buttons-container");

	id;
	type;
	dom;

	constructor(id, type){
		this.id = id;
		this.type = type;
		this.dom = this.getDOM();
		FilterButton.componentsContainer.append(this.dom);
		FilterButton.cache.push(this);
	}

	/**
	 * @returns {HTMLDivElement}
	 */
	getDOM(){
		const template = document.createElement("div");
		template.classList.add("dashboard-filter-button-component");

		return template;
	}
}

export default FilterButton;