class CustomerReviewRadioGroup{
	reviewInputsContainer = document.querySelector("#customer-review-container");
	noRadioButton = document.querySelector("#customer-review-check-no");
	yesRadioButton = document.querySelector("#customer-review-check-yes");

	constructor(){
		this.noRadioButton.addEventListener("change", () => {
			this.onNoChecked();
		});

		this.yesRadioButton.addEventListener("change", () => {
			this.onYesChecked();
		});
	}

	onNoChecked(){
		if (this.noRadioButton.checked){
			this.reviewInputsContainer.style.display = "none";
		}
	}

	onYesChecked(){
		if (this.yesRadioButton.checked){
			this.reviewInputsContainer.style.display = null;
		}
	}
}

export default CustomerReviewRadioGroup;