import CustomerReviewRadioGroup from "./components/CustomerReviewRadioGroup.js";
import AddImageComponentButton from "./components/AddImageComponentButton.js";
import ProjectTextualForm from "./forms/ProjectTextualForm.js";
import CoverPhotoFileInput from "./components/CoverPhotoFileInput.js";
import {ProjectTags} from "./components/ProjectTags.js";

export class ClientProjectForm{

	missingAcceloCompanyIDIntValue = parseInt(document.querySelector("#missing-accelo-company-id-input").value);
	projectFormContainer = document.querySelector("#client-project-form-page-container");
	projectFormLoader = document.querySelector("#client-project-form-loader");
	customerReviewRadioGroup;
	ProjectTags;

	constructor(){
		this.Init();
	}

	Init(){
		if (this.missingAcceloCompanyIDIntValue === 0){
			new CoverPhotoFileInput();
			this.customerReviewRadioGroup = new CustomerReviewRadioGroup();
			new AddImageComponentButton();
			new ProjectTextualForm(this);

			if (this.isTestForm()){
				this.fillOutTestInputs();
			}

			this.ProjectTags = new ProjectTags();
		}

		// By showing it in JS here, we can confirm that the browser has successfully loaded the JavaScript
		// with no syntax compatibility errors
		this.projectFormContainer.style.display = null;
		this.projectFormLoader.style.display = "none";
	}

	isTestForm(){
		const search = window.location.search;
		return search.includes("?test");
	}

	fillOutTestInputs(){
		document.querySelector("#project-title-input").value = `[Test] Project Form Title - City, ST`;
		document.querySelector("#project-description-input").value = `
			We conducted a fresh exterior painting job in the small town of CITY in ST.
			
			Our customer requested that we use Sherwin Williams paint on their 3,400 sqft brick and vinyl home. The fresh coat of paint is designed to last for 15 years. Our customer was pleased with the result and we were happy to liven up the exterior of their home.
		`.trim().replace(new RegExp("\t", "g"), "");
		document.querySelector("#project-location-city-input").value = `Dallas`;
		document.querySelector("#project-location-state-input").value = `TX`;
		document.querySelector("#project-budget-input").value = `$500.00`;
		document.querySelector("#project-materials-input").value = `Sherwin Williams Paints. Florida Orange Color.`;
		document.querySelector("#customer-review-check-yes").checked = true;
		this.customerReviewRadioGroup.onYesChecked();
		document.querySelector("#customer-first-name-input").value = `Trevor`;
		document.querySelector("#customer-last-name-input").value = `O.`;
		document.querySelector("#project-customer-testimonial-input").value = `After debating on a few cheaper contractors, we're glad we went with Company Name. The customer service and quality of work they performed on our home speaks volumes. We've caught our neighbors checking out our freshly painted home on more than one occasion!`;
	}
}

new ClientProjectForm();