class ActivityLog
{
	static activityLogsContainer = document.querySelector("#activity-log-rows-container");

	constructor(id, categoryID, userID, timestamp, jsonData, username, categoryDescription, timeAgo){
		this.id = id;
		this.categoryID = categoryID;
		this.userID = userID;
		this.timestamp = timestamp;
		this.jsonData = jsonData;
		this.username = username;
		this.categoryDescription = categoryDescription;
		this.timeAgo = timeAgo;
		this.dom = this.getDOM();

		ActivityLog.activityLogsContainer.append(this.dom);
	}

	getDOM(){
		let timeOfLogAction = new Date(this.timestamp * 1000);
		let formattedTimeOfLogAction = timeOfLogAction.toLocaleDateString("en-US", {year:"numeric", month:"short", day:"numeric"});

		const template = document.createElement("activity-log-row");
		let jsonDataObject = JSON.parse(this.jsonData);
		let collapseAnchor = "";
		let content = "";

		if(Object.keys(jsonDataObject).length === 0) {
			console.log("No valid data to display for this entry");
		} else {
			collapseAnchor = `
				<a class="text-decoration-none" data-bs-toggle="collapse" href="#collapse${this.id}" id="test${this.id}">
					Show Data
				</a>
			`;
			for(const [key, value] of Object.entries(jsonDataObject)) {
				content += `
					<div>
						<strong>${key}</strong>: ${value}
					</div>
				`;
			}
		}

		template.innerHTML = `
			<div class="row py-2 border-top activity-log category-${this.categoryID}">
				<div class="col-xl" style="max-width: 175px;">
					${formattedTimeOfLogAction}
				</div>
				<div class="col-xl d-flex flex-column">
					<div>
						<span>${this.username}</span> <em>${this.categoryDescription}</em> <span>${this.timeAgo}</span>
					</div>
					<div class="data-container">
						${collapseAnchor}
						<div class="collapse" id="collapse${this.id}">
							${content}
						</div>
					</div>
				</div>
			</div>
		`;

		return template;
	}
}

export default ActivityLog;