function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _onPageManuallyEnteredCallbacks = /*#__PURE__*/new WeakMap();
var _onPageNextCallbacks = /*#__PURE__*/new WeakMap();
var _onPagePrevCallbacks = /*#__PURE__*/new WeakMap();
var _Paginator_brand = /*#__PURE__*/new WeakSet();
var Paginator = /*#__PURE__*/function () {
  /**
   *
   * @param {HTMLElement} paginatorElement
   */
  function Paginator(paginatorElement) {
    var _this = this;
    _classCallCheck(this, Paginator);
    /**
     * Parses the page input as an integer and, if it's a valid integer, fires all the connected event listeners.
     */
    _classPrivateMethodInitSpec(this, _Paginator_brand);
    _classPrivateFieldInitSpec(this, _onPageManuallyEnteredCallbacks, []);
    _classPrivateFieldInitSpec(this, _onPageNextCallbacks, []);
    _classPrivateFieldInitSpec(this, _onPagePrevCallbacks, []);
    this.currentPage = 1;
    this.maxPages = 1;
    this.paginatorElement = paginatorElement;
    this.pageForm = this.paginatorElement.querySelector("form");
    this.pageInput = this.paginatorElement.querySelector("form input[type=\"number\"]");
    this.maxPagesElement = this.paginatorElement.querySelector(".paginator-max-pages");
    this.nextButton = this.paginatorElement.querySelector(".next-button");
    this.prevButton = this.paginatorElement.querySelector(".prev-button");
    this.pageForm.addEventListener("submit", function (e) {
      e.preventDefault();
      _assertClassBrand(_Paginator_brand, _this, _onPageFormSubmit).call(_this);
    });
    this.nextButton.addEventListener("click", function () {
      _assertClassBrand(_Paginator_brand, _this, _onNextButtonClicked).call(_this);
    });
    this.prevButton.addEventListener("click", function () {
      _assertClassBrand(_Paginator_brand, _this, _onPrevButtonClicked).call(_this);
    });
  }
  return _createClass(Paginator, [{
    key: "setCurrentPage",
    value: function setCurrentPage(currentPage) {
      this.currentPage = currentPage;
      this.pageInput.value = String(currentPage);
    }
  }, {
    key: "setMaxPages",
    value: function setMaxPages(maxPages) {
      this.maxPages = maxPages;
      this.maxPagesElement.textContent = String(maxPages);
    }
  }, {
    key: "onPageManuallyEntered",
    value: function onPageManuallyEntered(callback) {
      _classPrivateFieldGet(_onPageManuallyEnteredCallbacks, this).push(callback);
    }
  }, {
    key: "onPageNext",
    value: function onPageNext(callback) {
      _classPrivateFieldGet(_onPageNextCallbacks, this).push(callback);
    }
  }, {
    key: "onPagePrev",
    value: function onPagePrev(callback) {
      _classPrivateFieldGet(_onPagePrevCallbacks, this).push(callback);
    }
  }]);
}();
function _onPageFormSubmit() {
  var newPage = parseInt(this.pageInput.value);
  if (!isNaN(newPage)) {
    if (newPage > 0 && newPage <= this.maxPages) {
      this.setCurrentPage(newPage);
      var _iterator = _createForOfIteratorHelper(_classPrivateFieldGet(_onPageManuallyEnteredCallbacks, this)),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var callback = _step.value;
          callback(newPage);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  }
}
function _onNextButtonClicked() {
  var possibleNextPageNumber = this.currentPage + 1;
  if (possibleNextPageNumber <= this.maxPages) {
    this.setCurrentPage(possibleNextPageNumber);
    var _iterator2 = _createForOfIteratorHelper(_classPrivateFieldGet(_onPageNextCallbacks, this)),
      _step2;
    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var callback = _step2.value;
        callback(possibleNextPageNumber);
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
  }
}
function _onPrevButtonClicked() {
  var possiblePrevPageNumber = this.currentPage - 1;
  if (possiblePrevPageNumber > 0) {
    this.setCurrentPage(possiblePrevPageNumber);
    var _iterator3 = _createForOfIteratorHelper(_classPrivateFieldGet(_onPagePrevCallbacks, this)),
      _step3;
    try {
      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
        var callback = _step3.value;
        callback(possiblePrevPageNumber);
      }
    } catch (err) {
      _iterator3.e(err);
    } finally {
      _iterator3.f();
    }
  }
}
export default Paginator;