function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _dom = /*#__PURE__*/new WeakMap();
var _currentPage = /*#__PURE__*/new WeakMap();
var _maxPages = /*#__PURE__*/new WeakMap();
var _prevButtonClickEvents = /*#__PURE__*/new WeakMap();
var _nextButtonClickEvents = /*#__PURE__*/new WeakMap();
var _formSubmittedEvents = /*#__PURE__*/new WeakMap();
var _BSPaginator_brand = /*#__PURE__*/new WeakSet();
var BSPaginator = /*#__PURE__*/function () {
  /**
   * @param {HTMLElement} container
   */
  function BSPaginator(container) {
    _classCallCheck(this, BSPaginator);
    _classPrivateMethodInitSpec(this, _BSPaginator_brand);
    /** @type {HTMLElement} */
    _defineProperty(this, "container", void 0);
    /** @type {HTMLElement} */
    _classPrivateFieldInitSpec(this, _dom, void 0);
    _classPrivateFieldInitSpec(this, _currentPage, 1);
    _classPrivateFieldInitSpec(this, _maxPages, 1);
    _classPrivateFieldInitSpec(this, _prevButtonClickEvents, []);
    _classPrivateFieldInitSpec(this, _nextButtonClickEvents, []);
    _classPrivateFieldInitSpec(this, _formSubmittedEvents, []);
    this.container = container;
    _classPrivateFieldSet(_dom, this, _assertClassBrand(_BSPaginator_brand, this, _getDOM).call(this));
    this.container.append(_classPrivateFieldGet(_dom, this));
  }
  return _createClass(BSPaginator, [{
    key: "onPrevButtonClicked",
    value:
    /**
     * When the previous page button is clicked. Callback will be fired with the new page number
     * as an argument.
     * @param {function} callback
     */
    function onPrevButtonClicked(callback) {
      _classPrivateFieldGet(_prevButtonClickEvents, this).push(callback);
    }

    /**
     * When the next page button is clicked. Callback will be fired with the new page number
     * as an argument.
     * @param {function} callback
     */
  }, {
    key: "onNextButtonClicked",
    value: function onNextButtonClicked(callback) {
      _classPrivateFieldGet(_nextButtonClickEvents, this).push(callback);
    }

    /**
     * When the input field for the page number is submitted. Callback will be fired with the new page number
     * as an argument.
     * @param {function} callback
     */
  }, {
    key: "onPageNumberFormSubmitted",
    value: function onPageNumberFormSubmitted(callback) {
      _classPrivateFieldGet(_formSubmittedEvents, this).push(callback);
    }

    /**
     * Sets the current page on this Paginator. Updates the form value as well. Does not re-submit the form.
     * @param {int} currentPage
     */
  }, {
    key: "setCurrentPage",
    value: function setCurrentPage(currentPage) {
      _classPrivateFieldSet(_currentPage, this, currentPage);
      _classPrivateFieldGet(_dom, this).querySelector(".js-paginator-page-number-input").value = String(currentPage);
    }

    /**
     * Sets the maximum pages on this Paginator. Will update the textual display in the HTML component as well. If the new max pages is greater than the current page - setCurrentPage(maxPages) will be called by this method as well to clamp the current page to the maximum pages.
     * @param {int} maxPages
     */
  }, {
    key: "setMaxPages",
    value: function setMaxPages(maxPages) {
      _classPrivateFieldSet(_maxPages, this, maxPages);
      _classPrivateFieldGet(_dom, this).querySelector(".js-paginator-max-pages").textContent = String(maxPages);
      if (_classPrivateFieldGet(_maxPages, this) < _classPrivateFieldGet(_currentPage, this)) {
        this.setCurrentPage(maxPages);
      }
    }
  }]);
}();
function _firePrevButtonClickEvents() {
  var _iterator = _createForOfIteratorHelper(_classPrivateFieldGet(_prevButtonClickEvents, this)),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var callback = _step.value;
      callback(_classPrivateFieldGet(_currentPage, this));
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
}
function _fireNextButtonClickEvents() {
  var _iterator2 = _createForOfIteratorHelper(_classPrivateFieldGet(_nextButtonClickEvents, this)),
    _step2;
  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var callback = _step2.value;
      callback(_classPrivateFieldGet(_currentPage, this));
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
}
function _fireFormSubmittedEvents() {
  var _iterator3 = _createForOfIteratorHelper(_classPrivateFieldGet(_formSubmittedEvents, this)),
    _step3;
  try {
    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
      var callback = _step3.value;
      callback(_classPrivateFieldGet(_currentPage, this));
    }
  } catch (err) {
    _iterator3.e(err);
  } finally {
    _iterator3.f();
  }
}
function _getDOM() {
  var _this = this;
  var template = document.createElement("div");
  template.classList.add("js-paginator");
  template.innerHTML = "\n\t\t\t<div>\n\t\t\t\t<button type=\"button\" class=\"paginator-button prev-button btn btn-outline-primary\">\n\t\t\t\t\t<i class=\"bi bi-chevron-left\"></i>\n\t\t\t\t\t<span>Prev</span>\n\t\t\t\t</button>\n\t\t\t</div>\n\t\t\t<div class=\"js-paginator-form-container\">\n\t\t\t\t<form class=\"js-paginator-form\">\n\t\t\t\t\t<input name=\"page-number\" type=\"number\" class=\"js-paginator-page-number-input form-control\" value=\"1\">\n\t\t\t\t</form>\n\t\t\t\t<div>\n\t\t\t\t\t<span class=\"mx-1\">of</span> <span class=\"js-paginator-max-pages\">1</span>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div>\n\t\t\t\t<button type=\"button\" class=\"paginator-button next-button btn btn-outline-primary\">\n\t\t\t\t\t<span>Next</span>\n\t\t\t\t\t<i class=\"bi bi-chevron-right\"></i>\n\t\t\t\t</button>\n\t\t\t</div>\n\t\t";
  var prevButton = template.querySelector(".prev-button");
  var pageNumberForm = template.querySelector(".js-paginator-form");
  var nextButton = template.querySelector(".next-button");
  prevButton.addEventListener("click", function () {
    if (_classPrivateFieldGet(_currentPage, _this) > 1) {
      var _this$currentPage;
      _classPrivateFieldSet(_currentPage, _this, (_this$currentPage = _classPrivateFieldGet(_currentPage, _this), --_this$currentPage));
      _this.setCurrentPage(_classPrivateFieldGet(_currentPage, _this));
      _assertClassBrand(_BSPaginator_brand, _this, _firePrevButtonClickEvents).call(_this);
    }
  });
  nextButton.addEventListener("click", function () {
    if (_classPrivateFieldGet(_currentPage, _this) < _classPrivateFieldGet(_maxPages, _this)) {
      var _this$currentPage2;
      _classPrivateFieldSet(_currentPage, _this, (_this$currentPage2 = _classPrivateFieldGet(_currentPage, _this), ++_this$currentPage2));
      _this.setCurrentPage(_classPrivateFieldGet(_currentPage, _this));
      _assertClassBrand(_BSPaginator_brand, _this, _fireNextButtonClickEvents).call(_this);
    }
  });
  pageNumberForm.addEventListener("submit", function (e) {
    e.preventDefault();
    var fData = new FormData(pageNumberForm);
    var newPageNumber = parseInt(String(fData.get("page-number")));
    if (newPageNumber <= _classPrivateFieldGet(_maxPages, _this) && newPageNumber > 0) {
      _classPrivateFieldSet(_currentPage, _this, newPageNumber);
      _this.setCurrentPage(_classPrivateFieldGet(_currentPage, _this));
      _assertClassBrand(_BSPaginator_brand, _this, _fireFormSubmittedEvents).call(_this);
    }
  });
  return template;
}
export default BSPaginator;