function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import ConfirmModal from "../../utils/ConfirmModal.js";
import UserAccounts from "../UserAccounts.js";
import Endpoints from "../../Endpoints.js";
var Account = /*#__PURE__*/function () {
  /**
   * @param {int} id
   * @param {string} username
   * @param {string} firstName
   * @param {string} lastName
   * @param {string} role
   * @param {int} lastActivity
   */
  function Account(id, username, firstName, lastName, role, lastActivity) {
    _classCallCheck(this, Account);
    _defineProperty(this, "dom", null);
    _defineProperty(this, "id", void 0);
    _defineProperty(this, "username", void 0);
    _defineProperty(this, "firstName", void 0);
    _defineProperty(this, "lastName", void 0);
    _defineProperty(this, "role", void 0);
    _defineProperty(this, "lastActivity", void 0);
    this.id = id;
    this.username = username;
    this.firstName = firstName;
    this.lastName = lastName;
    this.role = role;
    this.lastActivity = lastActivity;
    this.dom = this.getDOM();
    Account.accountsContainer.append(this.dom);
  }

  /**
   * @returns {HTMLElement}
   */
  return _createClass(Account, [{
    key: "getDOM",
    value: function getDOM() {
      var dateString;
      var nameString = this.firstName;
      if (this.lastName.length > 0) {
        nameString += " ".concat(this.lastName);
      }
      if (this.lastActivity !== null) {
        dateString = new Date(this.lastActivity * 1000).toLocaleDateString();
      } else {
        dateString = "N/A";
      }
      var template = document.createElement("user-row");
      template.classList.add("users-columns");
      template.innerHTML = "\n\t\t\t<div class=\"username\">\n\t\t\t\t<span>".concat(this.username, "</span>\n\t\t\t</div>\n\t\t\t<div class=\"name\">\n\t\t\t\t<span>").concat(nameString, "</span>\n\t\t\t</div>\n\t\t\t<div class=\"role\">\n\t\t\t\t<span>").concat(this.role, "</span>\n\t\t\t</div>\n\t\t\t<div class=\"last-activity\">\n\t\t\t\t<span>").concat(dateString, "</span>\n\t\t\t</div>\n\t\t\t<div class=\"management-buttons\">\n\t\t\t\t<a href=\"/uplift/manage-user-accounts/").concat(this.id, "\" class=\"btn btn-sm btn-primary\">\n\t\t\t\t\t<i class=\"bi bi-person-video2\"></i>\n\t\t\t\t\t<span>Manage</span>\n\t\t\t\t</a>\n\t\t\t</div>\n\t\t");
      return template;
    }
  }]);
}();
_defineProperty(Account, "accountsContainer", document.querySelector("#users-rows-container"));
export default Account;